(define-module (alterator transport server-socket)
    :use-module (alterator algo)
    :use-module (alterator pipe)
    :export(server-socket))

(define next-gate (make-fluid))

(define (close-and-throw s args)
  (close s)
  (apply throw 're-send-system-error args))

(define (create-and-bind-socket socket-name)
 (define (bind-and-return s)
   (bind s AF_UNIX socket-name) s)

  (let ((s (socket PF_UNIX SOCK_STREAM 0)))
    (catch 'system-error
      (thunk (bind-and-return s))
      (lambda(key . args)
        (if (and (string? (car args)) (string=? (car args) "bind")
                 (number? (car (cadddr args))) (= (car (cadddr args)) 98))
            (catch 'system-error
              (thunk
                (connect s AF_UNIX socket-name)
                (close-and-throw s args)); oops ... something uses this socket
              (lambda(key2 . args2) ;ok remove and rebind
                (delete-file socket-name)
                (bind-and-return s)))
            (close-and-throw s args))))))

;read one command from new connection
(define (process-incoming next socket-port)
  (catch #t
    (thunk
     (with-ignored-sigpipe
      (thunk
       (let* ((connection (car (accept socket-port)))
              (cmd (read connection)))
         (or (eof-object? cmd)
             (let ((answer (next (list cmd) )))
               (write answer connection)))))))
    (lambda args #f))
  (process-incoming next socket-port))

(define (cond-caddr x)
  (and (pair? x)
       (pair? (cdr x))
       (pair? (cddr x))
       (caddr x)))

(define (server-socket . args)
  (let* ((socket-name (or (cond-car args) "/tmp/alterator-sock"))
         (socket-user (cond-cadr args))
         (socket-group (cond-caddr args))
         (socket-port (create-and-bind-socket socket-name)))
    (listen socket-port 10)
    (and socket-user
         socket-group
         (chown socket-name 
	        (passwd:uid (getpwnam socket-user))
	        (group:gid (getgrnam socket-group))))
    (chmod socket-name #o660)
    (lambda (cmds next)
      (process-incoming next socket-port))))
