(define-module (alterator transport std-channel)
  :use-module (alterator algo)
  :export(std-in))

(define next-gate (make-fluid))

(define (process-incoming run-once next)
  (let ((cmd (read)))
    (eat-rest (current-input-port))
    (write (next (list cmd)))
    (force-output (current-output-port)))
  (or run-once (process-incoming next)))
      
(define (std-in . run-once)
  (let ((one-time (if (pair? run-once) (car run-once) #f)))
    (lambda (cmds next)
      (process-incoming run-once next))))


