(define-module (alterator vector)
  :use-module (srfi srfi-1)
  :use-module (alterator container)
  :export (vector-resize
           vector-fit-size
	   vector-map))

;additional vector useful functions

(define (vector-resize vec len . fill-symbol)
  (let ((new-vec (apply make-vector len fill-symbol)))
    (container-replace! new-vec vec 0)
    new-vec))

(define (vector-fit-size vec len . fill-symbol)
  (cond
   ((not (vector? vec))
    (apply vector-resize (make-vector 1 vec) len fill-symbol))
   ((not (= len (vector-length vec)))
    (apply vector-resize  vec len fill-symbol))
   (else vec)))

(define (vector-map proc vec)
  (let* ((len (vector-length vec))
         (new-vec (make-vector len)))
    (let loop ((start 0))
      (if (< start len)
          (begin (vector-set! new-vec
                              start
                              (proc (vector-ref vec start)))
                 (loop (+ start 1)))
          new-vec))))

