(document:surround "/std/base")
(document:insert "/std/functions")

(document:envelop with-translation _ "alterator-apt")

(define (start)
  (add-mailbox message-handler)
  (add-mailbox error-handler)
  (woo-write "/apt/install"
             'job (or (global 'job) "install")
             'packages (string-join (or (global 'packages) '()) " ")))

(define (stop)
  (remove-mailbox message-handler)
  (remove-mailbox error-handler)
  (simple-notify document:root 'action "retry")
  
  (woo-delete "/ensign/apt"))

(define total (make-cell 0))
(define (total++ value)
  (cell-set! total (+ (cell-ref total) value)))

(define (string-prefix-at-pos str prefix pos)
  (and (string-prefix? prefix str)
       (list-ref (string-cut str #\:) pos)))

(define (ask-page-append str)
  (lambda(lst) (ask-page-details
                append-text (format #f "~A:~%~A~%" str lst))))

(define (error-handler msg)
  (and-let* ((error-text (cond-plistq 'error msg #f)))
            (error-page 1 append-text error-text)))

(define (message-handler args)
  (and-let* ((msg (cond-plistq 'message args #f)))
            (cond
             ;;yesno/finish
             ((string=? msg "apt-get:wait-yes-no:")
              (first-page invisible)
              (ask-page visibility #t))
             ((string-prefix-at-pos msg "apt-get:finish:" 2) =>
              (lambda(result)
                (stop)
                (if (string=? result "0")
                    (document:end 'ok)
                    (begin ((widgets first-page
                                     ask-page
                                     install-page) invisible)
                           (error-page visibility #t)))))
             ;;status collection
             ((string-prefix-at-pos msg "apt-get:status:upgrade:" 3) =>
              (lambda(count)
                (ask-page-upgrade text (format #f (_ "~A packages will be upgraded") count))
                (total++ (string->number count))))
             ((string-prefix-at-pos msg "apt-get:status:install:" 3) =>
              (lambda(count)
                (ask-page-install text (format #f (_ "~A packages will be installed") count))
                (total++ (string->number count))))
             ((string-prefix-at-pos msg "apt-get:status:remove:" 3) =>
              (lambda(count)
                (ask-page-remove text (format #f (_ "~A packages will be removed") count))))
             ((string-prefix-at-pos msg "apt-get:status:disk-size:" 3) =>
              (lambda(count)
                (ask-page-size
                 text
                 (format #f (_ "After installation ~A of disk space will be used") count))))
             ((string-prefix-at-pos msg "apt-get:extra-list:" 2) =>
              (ask-page-append (_ "Additional packages to install")))
             ((string-prefix-at-pos msg "apt-get:install-list:" 2) =>
              (ask-page-append (_ "Packages to install")))
             ((string-prefix-at-pos msg "apt-get:upgrade-list:" 2) =>
              (ask-page-append (_ "Packages to upgrade")))
             ((string-prefix-at-pos msg "apt-get:remove-list:" 2) =>
              (ask-page-append (_ "Packages to REMOVE")))
             ((string-prefix-at-pos msg "apt-get:replace-list:" 2) =>
              (ask-page-append (_ "Packages will be REPLACED")))
             ((string-prefix-at-pos msg "apt-get:keep-list:" 2) =>
              (ask-page-append (_ "Packages have been kept back")))

             ;;media change
             ((string-prefix? "apt-get:media-change:" msg)
              (let* ((msg (string-cut msg #\:))
                     (drive (list-ref msg 2))
                     (label (list-ref msg 3)))
                (media-page-label text label)
                (media-page-drive text drive)
                (first-page invisible)
                (media-page visibility #t)))

             ;;download progress
             ((string-match "^Get:[0-9]+" msg)
	      ((widgets ask-page first-page) invisible)
	      (install-page visibility #t)
              (install-page 0 text (_ "Acquiring packages..."))
	      (install-page 1 maximum (cell-ref total))
              (install-page 1 value (+ (install-page 1 value) 1)))

             ;;install progress
             ((string-prefix?  "Preparing..." msg)
              ((widgets ask-page first-page) invisible)
              (install-page visibility #t)
              (install-page 0 text (_ "Installing packages..."))
              (install-page 1 maximum (cell-ref total) value 0))
             ((string-match "^([^[:blank:]#]+)[[:space:]]*#.+" msg) =>
              (lambda(m)
                (install-page 1 value (+ (install-page 1 value) 1))
                (install-page 0 append-text (match:substring m 1)))))))

;;;;;;;;;;;;;;;;;;;;;;;;;
width 530
height 430

(document:id first-page
             (vbox (vertical-spacer)
                   (label (bold (_ "Preparing ....")))
                   (vertical-spacer)))

(document:id error-page
             (vbox invisible
                   (label (bold-red (_ "Fatal error")))
                   (textbox "" layout-policy 100 -2 alterability #f)
                   (label "")
                   (document:id error-page-exit (button (_ "Quit")))))

(document:id install-page
             (vbox invisible
                   (textbox (_ "Please wait...") alterability #f)
                   (progressbar layout-policy 100 -1 value 0 maximum 0)))

(document:id ask-page
             (vbox invisible
                   margin 10
                   (document:id ask-page-upgrade (label ""))
                   (document:id ask-page-install (label ""))
                   (document:id ask-page-remove  (label ""))
                   (document:id ask-page-size  (label ""))
                   (label "")
                   (document:id ask-page-see (button (_ "See details... ")))
                   (document:id ask-page-details (textbox "" alterability #f invisible))
                   (label "")
                   (label (bold (_ "Do you want to continue?")))
                   (label "")
                   (hbox layout-policy 100 -1
                         (document:id ask-page-y (button (_ "Yes") layout-policy 50 -1))
                         (document:id ask-page-n (button (_ "No") layout-policy 50 -1)))))

(document:id media-page
             (vbox invisible
                   margin 10
                   (label (_ "Please insert CDROM labeled as"))
                   (document:id media-page-label (label ""))
                   (label (_ "Into drive:"))
                   (document:id media-page-drive (label ""))
                   (vertical-spacer)
                   (document:id media-page-ok (button (_ "OK")))))

;;;;;;;;;;;;;;;;;;;;;;;;;
(start)

;;;;;;;;;;;;;;;;;;;;;;;;;
(media-page-ok (when clicked
                 (woo-write "/apt/notify" 'message "y")
                 (media-page invisible)
                 (first-page visibility #t)))
(ask-page-y (when clicked
              (woo-write "/apt/notify" 'message "y")
              (ask-page invisible)
              (first-page visibility #t)))
(ask-page-n (when clicked
              (woo-write "/apt/notify" 'message "n")
              (stop) (document:end 'cancel))) ;;don't wait for finish with exit code 1
(ask-page-see (when clicked
                (ask-page-details visibility #t)
                (ask-page-see inactive)))
(error-page-exit (when clicked (document:end 'ok)))
