(document:surround "/std/base")

(define pix "theme:disk-fd")

children-align center
(document:id lb
             (listbox
              columns 4
              header (vector "first" "second" "third" "forth" "ignored")
              rows `( #("1" ("2" . ,pix) "3" "4")
                      #("5")
                      #("6" ("7" . ,pix) "8")
                      #("9" "10" ("11" . ,pix) "12") )
              (layout-policy 90 -2)))

(button "append row"
        (when clicked
          (lb append-row #("new" "new" "new" ("new" . "theme:check-on")))
          (format #t "count=~S~%" (lb count))
          ))
(button "exchange texts"
        (when clicked
          (let ((txt1 (cond-car (lb row-item '(0 2))))
                (txt2 (cond-car (lb row-item '(2 1)))))
            (and txt1 txt2
                 (begin (lb row-item '(2 1) txt1)
                        (lb row-item '(0 2) txt2))))))
(button "exchange pixmaps"
        (when clicked
          (let ((pix1 (cond-cdr (lb row-item '(0 2))))
                (pix2 (cond-cdr (lb row-item '(2 1)))))
            (and pix1 pix2
                 (begin (lb row-item '(2 1) (cons #f pix1))
                        (lb row-item '(0 2) (cons #f pix2)))))))

(button "remove last row"
        (when clicked
          (lb remove (- (lb count) 1))))
