(document:surround "/std/base")


(label "Mailbox monitor:")
(document:id lb (listbox layout-policy 100 -2
                         header (vector "incoming messages")
                         rows '("messages ...") ))

(define (monitor msg)
  (lb append-row (format #f "~S" msg)))

(hbox
 layout-policy 100 -1
 (button "Clear"
         (when clicked
           (and (eq? 'ok (document:popup-question "Clear all messages?" 'ok 'cancel))
                (lb rows-clear))))
 (document:id start-button
              (button "Start"
                      (when clicked
                        (start-button activity #f)
                        (stop-button activity #t)
                        (add-mailbox monitor))))
 (document:id stop-button
              (button "Stop"
                      activity #f
                      (when clicked
                        (stop-button activity #f)
                        (start-button activity #t)
                        (remove-mailbox monitor)))) )
