(document:surround "/std/meta-attributes")

;; basic widgets
(document:envelop with-container-presentations
                  ((radio '/std/radio text)
                   (button '/std/button text)
                   (label '/std/label text)
                   (edit '/std/edit text)
                   (box '/std/box)
                   (spinbox '/std/spinbox)
                   (gridbox '/std/gridbox)
                   (groupbox '/std/groupbox title)
                   (textbox '/std/textbox text)
                   (tab-page '/std/tab-page text)
                   (tabbox '/std/tabbox)
                   (checkbox '/std/checkbox text)
                   (listbox '/std/listbox)
                   (combobox '/std/combobox)
                   (progressbar '/std/progressbar)
                   (slider '/std/slider)
                   (help-place '/std/help-place)
                   (tree '/std/tree)
                   (menubar '/std/menubar)
                   (spacer '/std/spacer)
		   (separator '/std/separator)
                   (dateedit '/std/dateedit)
		   (timeedit '/std/timeedit)))

;; composite widgets
(document:envelop with-container-presentations
                  ((checklist '/std/checklist)
		   (radiolist '/std/radiolist)))

(document:envelop with-attributes (
                                   ;checklist
                                   checklist-rows checklist-active-rows (checklist-row-item 2)
                                   checklist-policy checklist-append-row
                                                  
                                   ;radiolist
                                   radiolist-rows radiolist-current radiolist-append-row))

;;helper for tab
(define (tab name . args)
  (tab-page name (apply vbox args)))

;;helper for vertical box
(define (vbox . args)
  (apply box orientation 'vertical args))

;;helper for horizontal box
(define (hbox . args)
  (apply box orientation 'horizontal args))

;;;;;;;;;;;;;;;;;;;;;;;;;loops and splashes


;;helper for splash
(define (splash-message . arg)
  (let ((arg (if (null? arg) "" (car arg))))
    (simple-notify document:root
                   'action "splash" 'value arg)))

;;helper for release
(define (document:release)
  (define-operation pause)
  (simple-notify document:root 'action "retry")
  (pause (fluid-ref generic-session)))

;;exit current dialog modal loop
(define (document:end . arg)
  (define-operation stop)
  (stop (global 'document:loop) (if (null? arg) (unspecified) (car arg))))

;;;;;;;;;;;;;;;;;;;;;;;;;message boxes

(define (document:messagebox . args)
  (define-operation pause)
  (apply simple-notify document:root 'action "messagebox" args)
  (pause (fluid-ref generic-session)))

(define (document:popup-type type title message . buttons)
  (define (default-button args)
    (if (pair? args)
        (car args)
        'no-button))

  (document:messagebox
   'type type
   'title title
   'message message
   'buttons buttons
   'default-button (default-button buttons)))


(document:envelop with-translation _ "alterator-lookout")

(define (document:popup-information message . buttons)
  (apply document:popup-type "information" (_ "Information") message buttons))

(define (document:popup-warning message . buttons)
  (apply document:popup-type "warning" (_ "Warning") message buttons))


(define (document:popup-critical message . buttons)
  (apply document:popup-type "critical" (_ "Critical") message buttons))

(define (document:popup-question message . buttons)
  (apply document:popup-type "question" (_ "Question ") message buttons))


;;;;;;;;;;;;; woo-catch
(define (woo-catch/message proc)
  (woo-catch
   proc
   (lambda(reason) (document:popup-critical reason 'ok) #f)))


;;;;;;;;;;;;;;;;;;;;;;;;;constraints

(define (update-constraints action url . url-args)
  (woo-catch/message
   (thunk
      (simple-notify document:root 'action "constraints-clear")
      (plist-for-each (lambda (name constraints)
                        (plist-for-each (lambda (type params)
                                          (simple-notify document:root
                                                         'action "constraints-add"
                                                         'name name
                                                         'type type
                                                         'params params))
                                        constraints))
                      (read-constraints action url url-args))
      (simple-notify document:root 'action "constraints-apply"))))
