(document:surround "/std/meta-attributes")

;;including policy : identity == values; exluding : not
(define policy (make-cell values))

(define (value->pixmap value)
  (if ((cell-ref policy) value) "theme:check-on" "theme:check-off"))

(define (pixmap->value pixmap)
  ((cell-ref policy) (string=? pixmap "theme:check-on")))

(define (pixmap->pixmap pixmap)
  (if (string=? pixmap "theme:check-on")
      "theme:check-off"
      "theme:check-on"))

(define (checkitem->rowitem item)
  (if (pair? item)
      (cons (car item) (value->pixmap (cdr item)))
      (cons item (value->pixmap #t))))

(define (active-row-text x) (and (cdr x) (car x)))

(document:envelop
 with-proxy-attributes

 ((checklist-rows ((proxy-set self value)
                   (document:root rows (map checkitem->rowitem value)))
                  ((proxy-get self)
                   (map (lambda(x)
                          (let ((x (vector-ref x 0)))
                            (cons (car x) (pixmap->value (cdr x)))))
                        (document:root rows))))
  (checklist-append-row ((proxy-set self value)
                         (document:root append-row (checkitem->rowitem value))))
   
  (checklist-row-item 2
                      ((proxy-set self value)
                       (document:root row-item
                             (car value)
                             (cons #f (value->pixmap (cadr value)))))
                      ((proxy-get self)
                       (pixmap->value (cdr (apply document:root row-item (value-of self))))))

  (checklist-active-rows ((proxy-get self)
                          (filter-map active-row-text (document:root checklist-rows))))

  (checklist-policy ((proxy-set self value)
                     (cell-set! policy (if value values not)))
                    ((proxy-get self)
                     (eq? (cell-ref checklist-policy) values)))))

type "listbox"

(when clicked
  (let* ((pos  (document:root current))
         (old-pixmap (cdr (document:root row-item pos))))
    (document:root row-item pos (cons #f (pixmap->pixmap old-pixmap)))))
