;usefull functions to use in widget descriptions

(define inactive (activity #f))
(define invisible (visibility #f))
(define readonly (alterability #f))


(define (string-list-index str lst)
  (list-index (lambda (x) (string=? str x)) lst))

(define (bold-red txt)
  (string-append "<font color=\"red\"><b>"
                 txt
                 "</b></font>"))

(define (bold txt)
  (string-append "<b>" txt "</b>"))

(define (vertical-spacer . width)
  (label "" (layout-policy -1 (if (null? width) -2 (car width)))))

(define (horizontal-spacer . height)
  (label "" (layout-policy (if (null? height) -2 (car height)) -1)))

;apply same actions to group of widgets
(define (widgets . items)
  (lambda args
          (map (lambda (item) (apply item args))
	            items)))


;;;;;;;;;;;;;;; tree helpers

(define (row->branch row)
  (car (fold-right (lambda(x y)
               (list (cons x y)))
             '()
             row)))


(define (cond-cddr x)
  (and (pair? x)
       (pair? (cdr x))
       (pair? (cddr x))
       (cddr x)))

(define (join-rows row1 row2) ;expand row2 with row1
  (let loop ((row1 row1)
             (row2 row2))
    (if (equal? (car row1) (car row2))
        (if (pair? (cdr row1))
            (append (list (car row1))
                    (list (loop (cadr row1) (cadr row2)))
                    (or (cond-cddr row2) '()))
            row2)
        (append row1 row2))))

(define (rows->tree-items rows)
  (fold-right  (lambda(x y) 
                 (if (null? y) x (join-rows x y)))
               '()
               (map row->branch rows)))


;;;;;;;;;;;; actions helpers

(define (action-gensym result)
  (string->symbol
   (string-append "action" (number->string (length result)))))

(define (prepare-action-list lst)
  (reverse
   (plist-fold (lambda(name proc result)
                 (cond
                  ((pair? name)
                   (cons (list (car name) (cadr name) proc) result))
                  ((symbol? name)
                   (cons (list name #f proc) result))
                  ((string? name)
                   (cons (list (action-gensym result) name proc) result))
                  (else (error "wrong action name" name))))
               '()
               lst)))

(define (filter-actions lst)
  (filter-map (lambda(item)
                      (and (string? (cadr item))
                           (apply vector (list-head item 2))))
              lst))

(define (apply-actions widget . act-list)
  (let ((act-list (prepare-action-list act-list)))
     (widget actions (filter-actions act-list)
             (when clicked
               (let ((current (assq (widget current-action) act-list)))
                 (and (pair? current)
                      ((caddr current))))))))
