(document:surround "/std/attributes")

(document:insert "/std/meta-helpers")

(document:envelop with-meta-attributes
                  ;;default attributes
                  ((visibility ((default-get self) #t))
                   (activity   ((default-get self) #t))
                   (current    ((default-get self) -1))
                    
                   ;;various list properties
                   (header ((meta-set self widget)
                            (let* ((columns (or (simple-get widget columns) 1))
                                   (elts (vector-fit-size (car (value-of self)) columns "")))
                              (simple-set widget (header elts))
                              (simple-notify-set widget "header" elts))))

                   (rows ((meta-set self widget)
                          (let* ((columns (or (simple-get widget columns) 1))
                                 (elts (map (lambda(vec) (vector-fit-size vec columns ""))
                                            (concatenate (value-of self))))
                                 (u-elts (map unify-row elts)))
                            (simple-set widget (rows u-elts))
			    (simple-set widget (current -1))
                            (simple-notify-set widget "rows" u-elts))))
                   (append-row ((meta-set self widget)
                                (let* ((columns (or (simple-get widget columns) 1))
                                       (elt (unify-row (vector-fit-size
                                                        (car (value-of self))
                                                         columns ""))))
                                  (simple-set widget (rows (append1 (or (simple-get widget rows) '()) elt)))
                                  (simple-notify-set widget "append-row" elt))))
                   (row-item      2
                                  ((meta-get self widget)
                                   (and-let* ((coords (car (value-of self)))
                                              (column (safe-container-ref (simple-get widget rows)
                                                                          (if (pair? coords)
                                                                              (car coords)
                                                                              coords))))
                                             (safe-container-ref column (or (cond-cadr coords) 0) )))
                                  ((meta-set self widget)
                                   (let* ((value (value-of self))
                                          (item (meta-get self widget))
                                          (content (cadr value))
                                          (txt (if (pair? content) (car content) content))
                                          (pix (cond-cdr content)))
                                     (and item (string? txt)
                                          (begin (set-car! item txt)
                                                 (simple-notify-set
                                                  widget
                                                  "row-item-text"
                                                  (list txt (car value)))))
                                     (and item (string? pix)
                                          (begin (set-cdr! item pix)
                                                 (simple-notify-set
                                                  widget
                                                  "row-item-pixmap"
                                                  (list pix (car value))))))))
                   (rows-clear 0 ((meta-set self widget)
                                  (simple-set widget (current -1))
                                  (simple-set widget (rows '()))
                                  (simple-notify-set widget "rows-clear" "")))
                   (remove ((remove-one self widget lst number)
                            (and (list? lst)
                                 (begin
                                   (simple-set widget (rows lst))
                                   (simple-notify-set widget "remove-row" number))))
                           ((meta-set self widget)
                            (define-operation remove-one)
                            (let ((number (cond-car (value-of self))))
                              (simple-set widget (current -1))
                              (and (number? number)
                                   (remove-one self widget
                                               (safe-list-remove (simple-get widget rows) number)
                                               number)))))
                   (count ((meta-get self widget)
                           (length (or (simple-get widget rows) '()) )))

                   (text ((meta-get self widget)
                          (or (simple-get widget text);for widgets with real text property
                              (cond-car (meta-get (row-item (simple-get widget current))
                                                  widget))
                              "")))

                   ;;menubar attributes
                   (actions ((meta-set self widget)
                             (widget actions
                                     (map (lambda(item)
                                            (vector-fit-size item 3 ""))
                                          (car (value-of self))))))
                   (actions-clear 0 ((meta-set self widget)
                                     (simple-set widget (actions '() ))
                                     (simple-notify-set widget "actions-clear" "")))
                   (action-add ((meta-set self widget)
                                (let ((elt (vector-fit-size (car (value-of self)) 3 "")))
                                  (simple-set widget (actions (append1 (simple-get widget actions) elt)))
                                  (simple-notify-set widget "action-add" elt))))
                   (action-remove ((meta-set self widget)
                                   (let ((id (car (value-of self))))
                                     (simple-set widget
                                                 (actions
                                                  (filter (valid-action? id)
                                                          (simple-get widget actions))))
                                     (simple-notify-set widget "action-remove" id))))
                   
                   ;;textbox attributes
                   (append-text ((meta-set self widget)
                                 (let* ((prev-text (simple-get widget text))
                                        (app-text (string-join (value-of self) ""))
                                        (new-text (string-append prev-text
                                                                 (string #\newline)
                                                                 app-text)))
                                   (simple-set widget (text new-text))
                                   (simple-notify-set widget "text-append" app-text))))

                   ;;tree attributes
                   (tree-items ((meta-set self widget)
                                (let* ((columns (or (simple-get widget columns) 1))
                                       (elts (tree-map (lambda(vec) (vector-fit-size vec columns ""))
                                                       (concatenate (value-of self))))
                                       (u-elts (tree-map unify-row elts))
                                       (coords (make-coordinates u-elts)))
                                  (simple-set widget (tree-items u-elts))
                                  (simple-set widget (coordinates coords))
                                  (simple-set widget (current #f))
                                  (simple-notify-set widget "tree-items" u-elts)
                                  (simple-notify-set widget "coordinates" coords))))
                   (tree-text ((meta-get self widget)
                               (define (extract-text item)
                                 (car (vector-ref item 0)))
                               (let ((elt (tree-path (simple-get widget tree-items)
                                                     (simple-get widget current))))
                                 (map extract-text elt)))) ))
