(document:surround "/std/base")

(define active-item (make-cell -1))

(define (item->radio value)
  (let ((value (vector-ref value 0)))
    (vector (cons (car value) "theme:radio-off"))))

(document:envelop
 with-proxy-attributes

 ((rows ((proxy-set self value)
	 (lb rows (map item->radio value)))
        ((proxy-get self)
	 (lb rows)))

  (header ((proxy-set self value)
           (lb header value))
          ((proxy-get self)
           (lb header)))
  (selected ((proxy-set self value)
           (lb selected value))
          ((proxy-get self)
           (lb selected)))

  (text ((proxy-get self)
         (lb text)))

  (active  ((proxy-get self) (lb current))
           ((proxy-set self value) (lb current value)))
  (current  ((proxy-set self new)
             (let ((old (cell-ref active-item)))
               (and (number? new) (>= new 0)
                    (begin
                      (and (>= old 0)
                           (lb row-item old (cons #f "theme:radio-off")))
                      (lb row-item new (cons #f "theme:radio-on")
                          current new)
		      (cell-set! active-item new)))))
            ((proxy-get self)
                       (cell-ref active-item)))
  ))



type "vbox"
;;use internal listbox to avoid proxy-value/meta-value conflicts
(document:id lb (listbox layout-policy 100 100))
