;;this is a demo of simple authentication dialog
(document:surround "/std/base")
(document:insert "/std/functions")
(document:envelop with-translation _ "alterator")

title "Alterator"
width 500
height 170


(define languages '(("en" . "English")
                    ("be" . "Беларуская")
                    ("de" . "Deutsch")
                    ("fr" . "Français")
                    ("ru" . "Русский")
                    ("tt" . "Татар")
                    ("uk" . "Українська")))

(define current-language (let ()
                           (define-operation set-lang)
                           (and-let* ((l (global 'language))
			              ((not-empty-string? l))
                                      (ll (string-cut l #\;))
                                      (short-ll (map (lambda(x) (safe-substring x 0 2)) ll)))
                                     (set-lang (fluid-ref generic-session) ll)
                                     (any (lambda(choice)
                                            (list-index (lambda(item) (string=? (car item) choice))
                                                        languages))
                                          short-ll))))

(vertical-spacer)
(hbox layout-policy 100 -1
 margin 10
 (label "" pixmap "lisp-logo.png")
 (vbox layout-policy -2 -1
       (hbox layout-policy 100 -1
             (label "Username:" layout-policy 50 -1)
             (edit "" layout-policy -2 -1))
       (hbox layout-policy 100 -1
             (label "Password:" layout-policy 50 -1)
             (edit "" echo stars layout-policy -2 -1))
       (hbox layout-policy 100 -1
             (button "OK" layout-policy 50 -1
                     (when clicked
		       (define-operation set-live)
		       (set-live (fluid-ref generic-session) #t)
                       ;;you can add auth checking here
                       (document:replace '/)))
             (document:id
              langlist
              (combobox rows (map cdr languages)
                        (and current-language (current current-language))
                        layout-policy -2 -1
                        (when selected
                          (define-operation set-lang)
                          (set-lang (fluid-ref generic-session)
                                    (list (car (list-ref languages
                                                         (langlist current)))))))))))
                         
(vertical-spacer)
