#!/bin/sh -f

RSS_DIR="/var/lib/alterator/rss"

RSS_ERRORS=`find $RSS_DIR/critical/ -name '*.xml'`
RSS_WARNINGS=`find $RSS_DIR/warning/ -name '*.xml'`
RSS_MESSAGES=`find $RSS_DIR/normal/ -name '*.xml'`

rss_link()
{
    echo "https://$HTTP_HOST"
}

rss_title()
{
    title="$HOSTNAME"
    [ -n "$1" ] && title="$HOSTNAME:warning"
    [ -n "$2" ] && title="$HOSTNAME:Error!"
    
    echo "$title"
}

rss_tag()
{
sed "1 s,.*,<$1>&,
     $ s,.*,&</${1%% *}>,"
}

rss_head()
{
    rss_title "$RSS_WARNINGS" "$RSS_ERRORS" | rss_tag "title"
    echo "system monitoring1" | rss_tag "description"
    echo "en-us" | rss_tag "language"
    rss_link | rss_tag "link"
}

rss_single_item()
{
    local base=`basename $1`
    
    date -R -r "$1" | rss_tag "pubDate"
    printf '%s%s/index.scm/%s?rsstimestamp=%s\n' \
	"$rss_link" \
	"$(dirname "$SCRIPT_NAME")" \
	"${base%%.xml}" \
	"$(date '+%s' -r "$1")"	| rss_tag "link"
    cat "$1"
}

rss_all_items()
{
    for i in $RSS_ERRORS  $RSS_WARNINGS $RSS_MESSAGES;do
	rss_single_item "$i"| rss_tag "item"
    done
}

echo 'Content-Type:application/rss+xml'
echo

echo '<?xml version="1.0"?>'
(rss_head;rss_all_items)|
    rss_tag 'channel'|
    rss_tag 'rss version="2.0"'
