var features = {};

function addEvent(el, type, proc) {
        if (!el) return;
	if (el.addEventListener) {
		el.addEventListener(type, proc, false);
		return true;
	} else if (el.attachEvent) {
		return el.attachEvent("on"+type, proc);
	}
}

function removeEvent(el, type, proc) {
        if (!el) return;
	if (el.removeEventListener) {
		el.removeEventListener(type, proc, false);
		return true;
	} else if (el.detachEvent) {
		return el.detachEvent("on"+type, proc);
	}
}

function makeXMLHttpRequest(){
	if (window.XMLHttpRequest)
		return new XMLHttpRequest;
	else if (window.ActiveXObject)
		return new ActiveXObject('microsoft.xmlhttp');
	else
		return null;
}

/* node text content for browsers like Konqueror and Safari */
function nodeTextOld(node)
{
	var childrens = node.childNodes;
	var result="";

	for(var i=0;i< childrens.length;++i)
	{
	    var child = childrens.item(i);
	    switch (child.nodeType)
	    {
		case 1: //element node
		case 5: //entity reference node
		    result += nodeTextOld(child);
		    break;
		case 2: //attribute node
		case 3: //text node
		case 4: //cdata section node
		    result += child.nodeValue;
		    break;
		default:
		    break;
	    }
	}

	return result;
}

function nodeText(node)
{
	if (!node) return "";
	return node.textContent || node.text || nodeTextOld(node);
}
