function initExcludes()
{
	for (var i in excluders)
	{
		var elems = document.getElementsByName(i);
		addEvent(elems[0],"change",function(){ checkExcludes(false); });
	}
	
	var forms = document.forms;
	for(var i=0;i<forms.length;++i)
		addEvent(forms[i],"reset",function() { checkExcludes(true); });
}

function inputValue(name,useDefault)
{
	var elems = document.getElementsByName(name);
	if (!elems[0]) return elems[0];

	var input = elems[0];

	if (input.type == "checkbox")
	{
		var state = useDefault?input.defaultChecked:input.checked;
		return state?"#t":"#f";
	}
	else
		return useDefault?input.defaultValue:input.value;
}

function arrayContains(arr,value)
{
    for (i=0;i<arr.length;++i)
	if (arr[i] == value) return true;
    return false;
}

function needExclude(rules,useDefault)
{
	for(var i in rules) {
		if (arrayContains(rules[i],inputValue(i,useDefault))) return true;
	}
	return false;
}


function checkExcludes(useDefault)
{
	for (var i in excludings)
	{
		var elems = document.getElementsByName(i);
		var need = needExclude(excludings[i],useDefault);
		
		if (!elems[0]) continue;
		
		elems[0].disabled = need;
		// show/hide a required mark too
		var prev = elems[0].previousSibling;
		if (prev && prev.nodeName.toLowerCase() == "img") 
			prev.style.visibility = need?"hidden":"visible";
	}
}

////////////////////////////

function initRequired()
{
	var forms = document.getElementsByTagName('form');
	var has_marked = false;
	
	for(var i=0;i<forms.length;++i)
	{
		if (forms[i].getAttribute('highlight-required') == 'no')
		    continue;
		
		for(var j=0;j<required.length;++j)
		{
    	    	    var elem = forms[i].elements[required[j]];
		    
		    if (!elem) continue;
		    if (elem.type && elem.type == 'hidden') continue;
		    
		    has_marked = true;
		    
	    	    var icon = new Image();
		    icon.src ='/fbi/reqfield.gif';
		    icon.align='top';
		    elem.parentNode.insertBefore(icon,elem);
		}
	}

	//footer
	if (has_marked && (required.length > 0))
	{
		var footer = document.createElement("div");
		footer.className = 'constraints-footer'
		footer.innerHTML='<hr/><p>'+
				  po['fields marked with an']+
				  '<img src=\"/fbi/reqfield.gif\">'+
				  po['symbols are required']+
				  '</p>';
		document.body.appendChild(footer);
	}
}



////////////////////////////

function initConstraints()
{
	initExcludes();
	checkExcludes();

	initRequired();
}


addEvent(window,"load",initConstraints);

features.constraints = true;
