function getInputValue(input)
{
	if (input.nodeName.toLowerCase() == 'input')
		return input.value;
	else if (input.nodeName.toLowerCase() == 'select')
		return input.options[input.selectedIndex] &&
		       input.options[input.selectedIndex].value;
}

function makePostString(form)
{
	var values=[];
	var elements = form.elements;
	
	//simulate pressing to select button
	for (var i=0;i<elements.length;++i)
	{
		if (elements[i].type == 'submit' || elements[i].type == 'reset') continue;
		var value = getInputValue(elements[i]);
		if (!value) continue;
		values.push(encodeURIComponent(elements[i].name)+'='+encodeURIComponent(value));
	}
	values.push("card-index-select=yes");

	return values.join('&');
}

function findElementByName(lst,name)
{
	for(var i =0;i<lst.length;++i)
		if (lst[i].getAttribute('name') == name)
			return lst[i];
	return null;
}


function applySelectorInputs(rinputs,pinputs)
{
	for(var i=0;i<rinputs.length;++i)
	{
		var input = rinputs[i];
		if (input.type == 'text' || input.type == 'hidden')
		{
			var nvalue = findElementByName(pinputs,input.name);
			if (nvalue)
				input.defaultValue = input.value = nvalue.getAttribute('value');


		}
		else if (input.type == 'checkbox')
		{
			var nvalue = findElementByName(pinputs,input.name);
			if (nvalue)//Note: there are no  hasAttribute function in IE
				input.defaultChecked = input.checked = nvalue.getAttribute('checked')?true:false;
		}
	}
}

function applySelectorTextAreas(rinputs,pinputs)
{
	for(var i=0;i<rinputs.length;++i)
	{
		var input = rinputs[i];
		var nvalue = findElementByName(pinputs,input.name);
		if (nvalue)
		   input.defaultValue = input.value = nodeText(nvalue);
	}
}

function applySelectorSelects(rselects,pselects,main_select)
{
	function clearOptions(select)
	{
		while(select.length > 0)
			select.remove(select.length - 1);
	}
	
	function setupOptions(select,options)
	{
		for(var i = 0;i<options.length;++i)
		{
			var item = document.createElement('option');
			item.text = nodeText(options[i]);
			item.value = options[i].getAttribute('value');
			item.defaultSelected = item.selected = options[i].getAttribute('selected')?true:false;
			try{
				select.add(item,null);
			}catch(ex)
			{
				select.add(item);
			}
		}
	}
	
	for(var i = 0;i<rselects.length;++i)
	{
		var select = rselects[i];
		if (select == main_select) continue;
		var nvalue = findElementByName(pselects,select.name);
		if (!nvalue) continue;
		clearOptions(select);
		setupOptions(select,nvalue.getElementsByTagName('option'));
	}
}


function applySelector(page,selector)
{
	//we assume that we only update field state here, no page changes
	var pforms = page.getElementsByTagName('form');
	var rforms = document.getElementsByTagName('form');

	if (pforms.length != rforms.length) return;

	for(var i=0;i<pforms.length;++i)
	{
		if (pforms[i].getAttribute('class') != rforms[i].className)
			continue;
		var current_pform = pforms[i];
		var current_rform = rforms[i];
		//select all normal inputs
		applySelectorInputs(current_rform.getElementsByTagName('input'),
		                    current_pform.getElementsByTagName('input'));
		applySelectorTextAreas(current_rform.getElementsByTagName('textarea'),
		                       current_pform.getElementsByTagName('textarea'));
		applySelectorSelects(current_rform.getElementsByTagName('select'),
		                     current_pform.getElementsByTagName('select'),selector);
	}
}


function updateSelector(form,selector)
{
	var xmlhttp = makeXMLHttpRequest();
	if (!xmlhttp) return;


	xmlhttp.open('POST',document.location+"?async=yes",true);
	xmlhttp.setRequestHeader('Content-Type',	'application/x-www-form-urlencoded; charset=UTF-8');
	xmlhttp.onreadystatechange = function()
	                             {
				     	if (xmlhttp.readyState == 4)
					{
					     	var answer = xmlhttp.responseXML;
						if (xmlhttp.status == 200 && answer)
						{
							applySelector(answer,selector);
							if (features.constraints)
								checkExcludes();
						}
						delete xmlhttp;
				     	};
				     };
	xmlhttp.send(makePostString(form));
}

function initSelector()
{
	var form = document.getElementById('ajax-selector');
	if (!form) return;
	
	var selector = form.elements['name'];
	if (!selector ||  !selector.nodeName) return;

	addEvent(selector,'change',function() {updateSelector(form,selector);});
}

addEvent(window,'load',initSelector);
