function ajaxGetInputValue(input)
{
	if (input.nodeName.toLowerCase() == 'input')
		return input.value;
	else if (input.nodeName.toLowerCase() == 'select')
		return input.options[input.selectedIndex] &&
		       input.options[input.selectedIndex].value;
}

function ajaxMakePostString(form)
{
	if (!form) return '';

	var values=[];
	var elements = form.elements;
	
	//simulate pressing to select button
	for (var i=0;i<elements.length;++i)
	{
		if (elements[i].type == 'submit' || elements[i].type == 'reset') continue;
		var value = getInputValue(elements[i]);
		if (!value) continue;
		values.push(encodeURIComponent(elements[i].name)+'='+encodeURIComponent(value));
	}

	return values.join('&');
}

function ajaxSubmit(callback,id,method)
{
	var xmlhttp = makeXMLHttpRequest();
	if (!xmlhttp) return;

	xmlhttp.open(method || 'GET',document.location+"?async=yes"+"&msienocache=" + Math.random(),true);
	
	var request="";
	
	if (method == 'POST' && id)
	{
	    xmlhttp.setRequestHeader('Content-Type',	'application/x-www-form-urlencoded; charset=UTF-8');
	    request = makePostString(document.getElementById(id));
	}
	
	xmlhttp.onreadystatechange = function()
				    {
					if (xmlhttp.readyState == 4)
					{
					    var answer = xmlhttp.responseXML;
					    if (xmlhttp.status == 200 && answer) callback(answer);
					    delete xmlhttp;
				     	};
				    };
	xmlhttp.send(request);
}
