/*
 *  libwmfun - WindowMaker texture function library
 *  Copyright (C) 1999 Tobias Gloth
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 */

/*
 * $Id: wave.c,v 1.1.1.1 1999/02/21 17:16:47 gloth Exp $
 *
 * $Log: wave.c,v $
 * Revision 1.1.1.1  1999/02/21 17:16:47  gloth
 * initial revision
 *
 */

#include "getopt.h"
#include <math.h>
#include <stdlib.h>
#include <time.h>
#include <proplist.h>
#include <WINGs.h>
#include <WINGsP.h>

#include "generic.h"

static Display *ds_dpy = 0;
static Colormap ds_cmap;

void
initDrawString (proplist_t pl, void **init_data) {
    ds_dpy = init_data[0];
    ds_cmap = (Colormap) init_data[1];
    printf("init data %s\n",init_data[2]);
}

/* flicker!, using buffer should fix.
 * parsing color is slow, pl is faster,
 * should cache color -- ]d */

int getColor (const char *string, Colormap cmap, XColor *xcolor) {
	if (!XParseColor (ds_dpy, cmap, string, xcolor)) {
        return 0;
	}
    if (!XAllocColor (ds_dpy, cmap, xcolor)) {
        return 0;
    }

	return 1;
}

void
drawPlainString (proplist_t pl, Drawable d, GC gc,
        WMFont *font, int x, int y, unsigned width, unsigned height,
        char *text, int length)
{
    XColor color1, color2, color3, color4;
    char *plcolor;
    int i;
    static int g;
    Pixmap drawbuffer;

    /*
    printf("%d members\n",PLGetNumberOfElements(pl));
    for (i =0;i<7;i++) {
	    printf("%d %s\n",i,PLGetString(PLGetArrayElement(pl,i)));
    }
    return;
    */
#if 1
    drawbuffer = XCreatePixmap(ds_dpy, d,
            width, height*4+6, DefaultDepth(ds_dpy,(DefaultScreen(ds_dpy))));
    XCopyArea(ds_dpy, d, drawbuffer,gc,0,y-1,width,height,0,0);

    plcolor = PLGetArrayElement(pl, 5);

    if (getColor(PLGetString(plcolor),ds_cmap, &color3)) {
        XSetForeground(ds_dpy, gc, color3.pixel);

        if (font->notFontSet) {
            XSetFont(ds_dpy, gc, font->font.normal->fid);
            XDrawString(ds_dpy, drawbuffer, gc, x+3, font->y+3, text, length);
        } else {
            XmbDrawString(ds_dpy, drawbuffer, font->font.set, gc, x+4, y+4 + font->y,
                    text, length);
        }
    }

    plcolor = PLGetArrayElement(pl, 4);
    if (getColor(PLGetString(plcolor),ds_cmap, &color1)) {
        XSetForeground(ds_dpy, gc, color1.pixel);

        if (font->notFontSet) {
            XSetFont(ds_dpy, gc, font->font.normal->fid);
            XDrawString(ds_dpy, drawbuffer, gc, x+1, font->y+1, text, length);
        } else {
            XmbDrawString(ds_dpy, drawbuffer, font->font.set, gc, x, y + font->y,
                    text, length);
        }
    }

    plcolor = PLGetArrayElement(pl, 3);
    if (getColor(PLGetString(plcolor),ds_cmap, &color2)) {
        XSetForeground(ds_dpy, gc, color2.pixel);

        if (font->notFontSet) {
            XSetFont(ds_dpy, gc, font->font.normal->fid);
            XDrawString(ds_dpy, drawbuffer, gc, x,font->y, text, length);
        } else {
            XmbDrawString(ds_dpy, drawbuffer, font->font.set, gc, x-1, y-1 + font->y,
                    text, length);
        }
    }

    /*
    plcolor = PLGetArrayElement(pl, 6);
    parse_xcolor(PLGetString(plcolor), &color4);
    */

    XCopyArea(ds_dpy, drawbuffer, d,gc,0,0,width,height,0,y-1);

    XFreePixmap(ds_dpy, drawbuffer);
#endif
}

RImage *waves (int argc, char **argv, int width, int height, int relief) {

	int i, j, k, done, sine [256];
	int from[3] = { 0x00, 0x00, 0x00 };
	int to[3] = { 0xff, 0xff, 0xff };
	int layers, range, dx[1000], dy[1000];
	RImage *image;
	unsigned char *cptr;

	int option_index = 0;
	int c;

	optind = 1;
	for (done=0; !done; ) {
		static struct option long_options[] = {
			{"from", 1, 0, 'f'},
			{"to", 1, 0, 't'},
			{0, 0, 0, 0}
		};

		c = getopt_long (argc, argv, "f:t:",
			long_options, &option_index);
		if (c == -1) {
			break;
		}

		switch (c) {
		case 'f':
			if (!parse_color (optarg, from)) {
				error ("invalid color: %s\n", optarg);
				return 0;
			}
			break;
		case 't':
			if (!parse_color (optarg, to)) {
				error ("invalid color: %s\n", optarg);
				return 0;
			}
			break;
		default:
			done = 1;
			break;
		}
	}

	argc -= optind;
	argv += optind;

	if (!start_image ("waves", argc, 2, 3, width, height, &image)) {
		return (RImage *)0;
	}

	layers = atoi (argv[0]);
	range = atoi (argv[1]);

	if (layers <= 0) {
		layers = 1;
	}
	if (layers > 256) {
		layers = 256;
	}

	if (range <= 0) {
		range = 1;
	}

	for (i=0; i<256; i++) {
		sine[i] = (int) (127.0 * sin (2.0 * M_PI * i / 256)) + 128;
	}

	srand (time (0));

	for (i=0; i<layers; i++) {
		dx[i] = random_int (range) - range / 2;
		dy[i] = random_int (range) - range / 2;
	}

	cptr = image->data;
	for (i=0; i<height; i++) {
		for (j=0; j<width; j++) {
			int output[3], value = 0;
			for (k=0; k<layers; k++) {
				value += sine[(j*dx[k]+i*dy[k]) & 255];
			}
			interpolate_color (output, from, to, value / layers);
			*cptr++ = output[0];
			*cptr++ = output[1];
			*cptr++ = output[2];
			if ( RRGBAFormat==image->format )
				cptr++;
		}
	}

	return image;
}

